/*
 * g3g_dbusappbase.cpp
 *
 *  Created on: Sep 18, 2012
 *      Author: rjk2hi
 */

#include "g3g_dbus.h"
#include <iostream>
#include <signal.h>

/*
 * Static variables initialization
 */
static bool l_bAppClosed = false;

#ifndef DISABLE_DISPATCHER_THREAD
pthread_t g_dispatchthread;//Thread id
#endif
g3g_dbusappbase* g3g_dbusappbase::m_poSelf= NULL;

#ifndef DISABLE_DISPATCHER_THREAD
/*
 * Dispatching thread entry function
 */
static void* vDispatcherEntry(void* pvarg)
{
	if(pvarg != NULL)
	{
		pSocketHandler()->start_listenting();
	}
#ifdef DEBUG_ENABLE
	std::cout<<"Disptacher thread exit"<<std::endl;
#endif
	return NULL;
}
#endif

/*
 * Handler for Process terminate signals
 */
void g3g_dbusappbase::vHandleProcTermSignal(int isignal)
{
	if(m_poSelf != NULL)
	{
		switch(isignal)
		{
		case SIGTERM:
		case SIGINT:
		{
			l_bAppClosed = true;
			m_poSelf->vOnAppClose();//Inform child that appclose is triggered
			pSocketHandler()->stop_listening();//stop listening
//			std::cout<<"Stopped listening"<<std::endl;
		}
		break;
		default:
			break;
		}
	}
}
/*
 * Constructor
 */
g3g_dbusappbase::g3g_dbusappbase()
{
	if(g3g_dbusappbase::m_poSelf == NULL)
	{
		g3g_dbusappbase::m_poSelf = this;

		//Registering for Term signals
		signal(SIGTERM, &vHandleProcTermSignal);
		signal(SIGINT, &vHandleProcTermSignal);
	}
}

bool g3g_dbusappbase::bStartApp()
{
	//Invoke bOnAppInit of application
	if(bOnAppInit())
	{
#ifndef DISABLE_DISPATCHER_THREAD
		pthread_attr_t 		l_dispatcher_attr;

		//Initialize thread attributes
		pthread_attr_init(&l_dispatcher_attr);

		//Run the socket handler main loop in a separate thread
		if(0 != pthread_create(&g_dispatchthread, &l_dispatcher_attr,::vDispatcherEntry, this))
		{
			std::cout <<"Failed to Start dispatcher thread"<<std::endl;
			return false;
		}
#else
		std::cout<<"Listening Started"<<std::endl;
		pSocketHandler()->start_listenting();
#endif
	}
	return true;
}

/*
 * Destructor
 */
g3g_dbusappbase::~g3g_dbusappbase()
{
	//Do what ??
}

bool g3g_dbusappbase::bAppClosed() const
{
	return ::l_bAppClosed;
}
